
#include"rfc_amalgamated.h"
#include"moduleapi.h"
#include"resource.h"

//http://192.168.1.9:8001/1:0:1:82:65:1:2FD0F50:0:0:0:


class ExampleWindow : public KHotPluggedDialog, public KButtonListener,public KThread
{
	KButton btn1,btn2,btn3,btn4;
	KTextBox txt,txt2;
	KComboBox combo;
	KIcon icon;

	HMODULE hModPlugin;
	TModuleInfo tModuleInfo;
	TInitInfo tInitInfo;
	LPF_OnModuleShow onModuleShow;
	LPF_OnModuleClose onModuleClose;
	LPF_BeforeChannelChange onBeforeChannelChange;
	LPF_AfterChannelChange onAfterChannelChange;

	TChannelInfo channelInfo;
	TAudioInfo audioInfo;
	TCAInfo ecmInfo;

	volatile LPF_StreamCB *streamCB;

public:

	void OnHotPlug()
	{
		// you must call this method to update width, height etc...
		KHotPluggedDialog::OnHotPlug();

		streamCB = 0;
		populateChannelInfo();

		btn1.HotPlugInto(GetDlgItem(compHWND,IDOK));
		btn1.SetListener(this);

		btn2.HotPlugInto(GetDlgItem(compHWND,IDCANCEL));
		btn2.SetListener(this);

		btn3.HotPlugInto(GetDlgItem(compHWND, IDC_BUTTON1));
		btn3.SetListener(this);

		btn4.HotPlugInto(GetDlgItem(compHWND, IDC_BUTTON2));
		btn4.SetListener(this);

		txt.HotPlugInto(GetDlgItem(compHWND,IDC_EDIT1));
		txt2.HotPlugInto(GetDlgItem(compHWND, IDC_EDIT2));

		SetText(L"PowerVU TS Decrypter v1.0");

		CenterScreen();

		hModPlugin = LoadLibraryW(L"d:\\powervu\\PowerVu.dll");
		if (hModPlugin != 0)
		{

			// OnGetModuleInfo
			LPF_OnGetModuleInfo onGetModuleInfo = (LPF_OnGetModuleInfo)GetProcAddress(hModPlugin, "OnGetModuleInfo");
			tModuleInfo.hMainWnd = compHWND;
			tModuleInfo.dwModuleAPI = MODULE_API_2_6;
			onGetModuleInfo(&tModuleInfo);

			txt2.SetText(tModuleInfo.szModuleName);

			// OnModuleInit
			tInitInfo.hMainWnd = compHWND;
			LPF_OnModuleInit onModuleInit = (LPF_OnModuleInit)GetProcAddress(hModPlugin, "OnInit");
			onModuleInit(&tInitInfo);

			// OnModuleShow
			onModuleShow = (LPF_OnModuleShow)GetProcAddress(hModPlugin, "OnShow");

			// OnModuleClose
			onModuleClose = (LPF_OnModuleClose)GetProcAddress(hModPlugin, "OnClose");

			// BeforeChannelChange
			onBeforeChannelChange = (LPF_BeforeChannelChange)GetProcAddress(hModPlugin, "BeforeChannelChange");

			// AfterChannelChange
			onAfterChannelChange = (LPF_AfterChannelChange)GetProcAddress(hModPlugin, "AfterChannelChange");
		}
		else
		{
			MessageBoxW(compHWND, L"plugin load failed", L"Error", MB_OK);
		}
	}

	void populateChannelInfo()
	{

		channelInfo.wVideo = 0x0938; // video pid
		channelInfo.wPMT = 0x140a; // PMT pid
		audioInfo.wPID[0] = 0x0910; // audio pid
		ecmInfo.wPID[0] = 0x17f2; // ecm pid
		channelInfo.wSID = 0x0082; // ? from PowerVU emu



		channelInfo.dwSize = sizeof(TChannelInfo);
		channelInfo.wNID = 0x00; // network	
		channelInfo.wSatPos = 0; // ?
		channelInfo.dwChId = 0; // ? assume program number
		strcpy(channelInfo.ChName, "my channel");
		strcpy(channelInfo.Provider, "my provider");
		channelInfo.ChType = CHTYPE_TV; // channel type
		channelInfo.Scrambled = 0xff; // scrambled assume 0xff means true
		channelInfo.wPCR = 0x00; // PCR pid
		channelInfo.wTTX = 0; // TTX pid
		channelInfo.wChNo = 0; // ? assume program number
		channelInfo.wTID = 0x0000; // ? assume Transport Stream ID

		audioInfo.wCurrent = 0; // current index
		audioInfo.wCount = 1; // audio pids
		//audioInfo.wPID[1] = 0x0912; // audio pid
		//audioInfo.wPID[2] = 0x02aa; // audio pid
		audioInfo.dwFlags[0] = AUDIO_ISO13818; // MPEG-2 Audio
		//audioInfo.dwFlags[1] = AUDIO_ISO13818; // MPEG-2 Audio
		//audioInfo.dwFlags[2] = AUDIO_ISO13818; // MPEG-2 Audio

		channelInfo.Audio = audioInfo;

		ecmInfo.wCurrent = 0;
		ecmInfo.wCount = 1; // ecm pids
		ecmInfo.wCAType[0] = 0x0e00; // ? assume CA System ID
		

		channelInfo.ECM = ecmInfo;
		channelInfo.EMM = ecmInfo;
	}

	void Run()
	{

		while (!streamCB){}

		unsigned char *buf = (unsigned char *)malloc(188);

		int pOutLen=0;
		
		FILE *file = fopen(txt.GetText(), "rb");
		FILE *outFile = fopen("d:\\out.ts", "wb");

		ZeroMemory(buf, 188);

		if (file)
		{
			while ((!threadShouldStop)  )
			{
				pOutLen = 0;

				if (feof(file))
				{
					MessageBoxW(compHWND, L"end of file reached!", L"Info", MB_OK);
					break;
				}

				fread(buf, 1, 188, file);

				if (!streamCB)
				{
					MessageBoxW(compHWND, L"streamCB set to zero", L"Error", MB_OK);
					break;
				}
				streamCB(buf, 188, 0, &pOutLen);

				fwrite(buf, 1, 188, outFile); // write to output

				ZeroMemory(buf, 188);

			}
			fclose(file);
		}
		else
		{
			MessageBoxW(compHWND, L"cannot read ts file", L"error", MB_OK);
		}

		fclose(outFile);

		isThreadRunning = false;

		btn4.SetEnabled(true);

		free(buf);
	}

	LRESULT WindowProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
	{
		if (msg == WM_MODULE_MSG)
		{
			if (wParam == DDMODAPI_SET_STREAM_CB)
			{

				//MessageBoxW(compHWND, L"WM_MODULE_MSG - DDMODAPI_SET_STREAM_CB", L"info", MB_OK);
				streamCB = (LPF_StreamCB*)lParam;

			}
			else if (wParam == DDMODAPI_FREE_STREAM_CB)
			{
				streamCB = 0;
				//MessageBoxW(compHWND, L"DDMODAPI_FREE_STREAM_CB called", L"info", MB_OK);
			}
			else if (wParam == DDMODAPI_GET_CHANNEL_INFO)
			{
				TChannelInfo *chInfo = (TChannelInfo*)lParam;
				memcpy(chInfo, &channelInfo, sizeof(TChannelInfo));
			}
			else
			{
				KString text = KString(L"WM_MODULE_MSG - unknown: ") + KString(wParam, 16);
				MessageBoxW(compHWND, text, L"info", MB_OK);
			}

			return 0;
		}
		return KHotPluggedDialog::WindowProc( hwnd,  msg,  wParam,  lParam);
	}

	void OnButtonPress(KButton *button)
	{
		if(button==&btn1)
		{
			KString fileName;
			char curDir[512];
			GetCurrentDirectoryA(512,curDir);

			if (KCommonDialogBox::ShowOpenFileDialog(this, L"Open TS File...", L"TS Files(*.ts)\0 * .ts\0", &fileName))
			{
				txt.SetText(fileName);
				SetCurrentDirectoryA(curDir);
			}
		}
		else if(button==&btn2)
		{
			ThreadShouldStop();
		}
		else if (button == &btn3)
		{
			if (hModPlugin != 0)
			{
				onModuleShow();
			}
		}
		else if (button == &btn4) // decode button press
		{
			if (hModPlugin != 0)
			{


				/*
				channelInfo.dwSize = sizeof(TChannelInfo);
				channelInfo.wNID = 0x0010; // network
				channelInfo.wSID = 0x0082; // ? from PowerVU emu
				channelInfo.wSatPos = 0; // ?
				channelInfo.dwChId = 130; // ? assume program number
				strcpy(channelInfo.ChName, "my axn");
				strcpy(channelInfo.Provider, "my provider");
				channelInfo.ChType = CHTYPE_TV; // channel type
				channelInfo.Scrambled = 0xff; // scrambled assume 0xff means true
				channelInfo.wVideo = 0x0938; // video pid
				channelInfo.wPMT = 0x140a; // PMT pid
				channelInfo.wPCR = 0x0938; // PCR pid
				channelInfo.wTTX = 0; // TTX pid
				channelInfo.wChNo = 130; // ? assume program number
				channelInfo.wTID = 0x0065; // ? assume Transport Stream ID

				audioInfo.wCurrent = 0;
				audioInfo.wCount = 2; // audio pids
				audioInfo.wPID[0] = 0x0910; // audio pid
				audioInfo.wPID[1] = 0x0912; // audio pid
				audioInfo.dwFlags[0] = AUDIO_ISO13818; // MPEG-2 Audio
				audioInfo.dwFlags[1] = AUDIO_ISO13818; // MPEG-2 Audio

				channelInfo.Audio = audioInfo;

				ecmInfo.wCurrent = 0;
				ecmInfo.wCount = 1; // ecm pids
				ecmInfo.wCAType[0] = 0x0e00; // ? assume CA System ID
				ecmInfo.wPID[0] = 0x17f2; // ecm pid

				channelInfo.ECM = ecmInfo;
				channelInfo.EMM = ecmInfo;*/

				onBeforeChannelChange(&channelInfo);
				onAfterChannelChange(&channelInfo);

				btn4.SetEnabled(false);

				StartThread(); // start decoding thread
			}
		}
	}

	void OnClose()
	{
		if (hModPlugin != 0)
		{
			onModuleClose();
			FreeLibrary(hModPlugin);
		}

		EndDialog(compHWND, 0);
	}
};


class ExampleApp : KApplication
{
public:
	int Main(KString **argv,int argc)
	{
		ExampleWindow wnd;

		HotPlugAndRunDialogBox(IDD_DIALOG1,0,&wnd);

		return 0;
	}
};

START_RFC_APPLICATION(ExampleApp)
